// PR_FTPDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PR_FTP.h"
#include "PR_FTPDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CPR_FTPDlg dialog




CPR_FTPDlg::CPR_FTPDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPR_FTPDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPR_FTPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, list1);
	DDX_Control(pDX, IDC_EDIT1, editAddr);
	DDX_Control(pDX, IDC_EDIT2, editLogin);
	DDX_Control(pDX, IDC_EDIT3, editPass);
	DDX_Control(pDX, IDC_BUTTON2, buttonZakoncz);
	DDX_Control(pDX, IDC_BUTTON3, buttonPobierz);
	DDX_Control(pDX, IDC_BUTTON4, buttonZaladuj);
}

BEGIN_MESSAGE_MAP(CPR_FTPDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CPR_FTPDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CPR_FTPDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CPR_FTPDlg::OnBnClickedButton3)
    ON_BN_CLICKED(IDC_BUTTON4, &CPR_FTPDlg::OnBnClickedButton4)
END_MESSAGE_MAP()


// CPR_FTPDlg message handlers

BOOL CPR_FTPDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	RECT r;
	list1.GetWindowRect(&r);

	int szerListy = r.right - r.left;
	int szerKolumny = szerListy / 2;

	list1.InsertColumn(0,L"Nazwa pliku",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(1,L"Typ",LVCFMT_LEFT, szerKolumny, 0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPR_FTPDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPR_FTPDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CPR_FTPDlg::OnBnClickedButton1()
{
	// TODO: Add your control notification handler code here
	CString serwAddr,login,pass;

	editAddr.GetWindowText(serwAddr);
	editLogin.GetWindowText(login);
	editPass.GetWindowText(pass);
	
	if(ftp.Polacz(serwAddr,login,pass,list1))
	{
		buttonZakoncz.EnableWindow();
		buttonPobierz.EnableWindow();
		buttonZaladuj.EnableWindow();
	}
}

void CPR_FTPDlg::OnBnClickedButton2()
{
	// TODO: Add your control notification handler code here
	if(ftp.ZakonczPolaczenie())
	{
		list1.DeleteAllItems();
		buttonZakoncz.EnableWindow(false);
		buttonPobierz.EnableWindow(false);
		buttonZaladuj.EnableWindow(false);
	}
}

void CPR_FTPDlg::OnBnClickedButton3()
{
	// TODO: Add your control notification handler code here

	CString nazwaPliku;
	bool plik = false;
	for(int i=0;i<list1.GetItemCount();i++)
	{
		if(list1.GetItemState(i,LVIS_SELECTED) & LVIS_SELECTED)
		{
			CString hwndText = list1.GetItemText(i, 1);
			if(hwndText.Compare(L"Katalog") == 0)
			{
				MessageBox(L"Nie mona ciga katalogw");
				return ;
			}
			else
			{
				nazwaPliku = list1.GetItemText(i,0);
				plik = true;
			}
		}
	}

	if(!plik) 
	{
		MessageBox(L"Nie wybrano pliku");
		return ;
	}	
	fileDialog = new CFileDialog(false,0,nazwaPliku);
	if(!fileDialog) return;
	if(fileDialog->DoModal() == IDOK)
	{
		if(ftp.PobierzPlik(nazwaPliku,fileDialog->GetFileName())) MessageBox(L"Pomylnie zapisano plik");
	}
	delete fileDialog;
}

void CPR_FTPDlg::OnBnClickedButton4()
{
    // TODO: Add your control notification handler code here
    // TODO: Add your control notification handler code here
    fileDialog = new CFileDialog(true);
    if(fileDialog->DoModal() == IDOK)
	{
		CString file;
		file.AppendFormat(L"%s.%s",fileDialog->GetFileTitle(),fileDialog->GetFileExt());
        if(ftp.DodajPlik(fileDialog->GetFileName(),file)) MessageBox(L"Pomylnie zapisano plik");
	}

}
